/**
 * A javascript module that handles the change of the user's visibility in the
 * online users block.
 *
 * @module     block_online_users/change_user_visibility
 * @copyright  2018 Mihail Geshoski <mihail@moodle.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("block_online_users/change_user_visibility",["jquery","core/ajax","core/str","core/notification"],(function($,Ajax,Str,Notification){var SELECTORS_CHANGE_VISIBILITY_LINK="#change-user-visibility",SELECTORS_CHANGE_VISIBILITY_ICON="#change-user-visibility .icon",oppositeAction=function(action){return"show"==action?"hide":"show"},changeVisibilityLinkAttr=function(action){getTitle(action).then((function(title){$(SELECTORS_CHANGE_VISIBILITY_LINK).attr({"data-action":action,title:title})})).catch(Notification.exception)},changeVisibilityIconAttr=function(action){var icon=$(SELECTORS_CHANGE_VISIBILITY_ICON);getTitle(action).then((function(title){$(icon).attr({title:title,"aria-label":title}),icon.is("img")?$(icon).attr({src:M.util.image_url("t/"+action),alt:title}):($(icon).addClass(getIconClass(action)),$(icon).removeClass(getIconClass(oppositeAction(action))))})).catch(Notification.exception)},getIconClass=function(action){return"show"==action?"fa-eye-slash":"fa-eye"},getTitle=function(action){return Str.get_string("online_status:"+action,"block_online_users")};return{init:function(){$(SELECTORS_CHANGE_VISIBILITY_LINK).on("click",(function(e){e.preventDefault(),function(action,userid){var request={methodname:"core_user_set_user_preferences",args:{preferences:[{name:"block_online_users_uservisibility",value:"show"==action?1:0,userid:userid}]}};Ajax.call([request])[0].then((function(data){if(data.saved){var newAction=oppositeAction(action);changeVisibilityLinkAttr(newAction),changeVisibilityIconAttr(newAction)}})).catch(Notification.exception)}($(this).attr("data-action"),$(this).attr("data-userid"))}))}}}));

//# sourceMappingURL=change_user_visibility.min.js.map