/**
 * Load the format_tiles JavaScript for the course edit settings page /course/edit.php?id=xxx
 *
 * @module      format_tiles/completion
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("format_tiles/completion",["jquery","core/templates","core/config","core/ajax","core/str","core_course/manual_completion_toggle"],(function($,Templates,config,ajax,str,coreManualCompletion){var courseId;const Selector_section="li.section.main",Selector_toggleCompletionSubtile='[data-action="tiles-toggle-manual-completion-subtile"]',Selector_tileNumber="#tile-",Selector_tile=".tile",Selector_spacer=".spacer",Selector_availabilityinfo=".availabilityinfo",isRTL="rtl"===$("html").css("direction"),setProgressIndicator=function(sectionNumber,numComplete,numOutOf){if(!numOutOf||numComplete<0)return;const tileProgressIndicator=$("#tileprogress-"+sectionNumber);if(tileProgressIndicator.length){const percent=numOutOf>0?Math.round(numComplete/numOutOf*100):0;tileProgressIndicator.attr("data-numcomplete",numComplete),tileProgressIndicator.attr("data-numoutof",numOutOf),tileProgressIndicator.find(".num-complete").html(numComplete),tileProgressIndicator.find(".num-out-of").html(numOutOf),tileProgressIndicator.find(".percent-complete").html(percent),tileProgressIndicator.find("svg circle.partial").attr("stroke-dashoffset",numOutOf>0?Math.round((numOutOf-numComplete)/numOutOf*106.8):0);const svgX=isRTL?percent<10?25:30:percent<10?15:10;if(tileProgressIndicator.find("svg text").html(percent).attr("x",svgX),str.get_strings([{key:"progresstitle",component:"format_tiles",param:{numOutOf:numOutOf,numComplete:numComplete,percent:percent}}]).done((function(s){tileProgressIndicator.prop("title",s[0]),$("#tile-"+sectionNumber).find(".completion-bar").css("width","".concat(percent,"%")).attr("title",s[0])})),0===sectionNumber){const overallProgressOuter=$("#tiles-overall-progress-outer");100===percent?overallProgressOuter.addClass("is-complete"):overallProgressOuter.removeClass("is-complete")}}},triggerCompletionChangedEvent=function(sectionNum,cmId){if(sectionNum>0||cmId>0){const data={courseid:courseId,section:sectionNum,cmid:cmId};$(document).trigger("format-tiles-completion-changed",data)}},updateSectionsInfo=function(sections,overallcomplete,overalloutof){sections.forEach((sec=>{if(sec.sectionnum>0){const tile=$(Selector_tileNumber+sec.sectionnum);sec.isavailable&&tile.hasClass("tile-restricted")?tile.removeClass("tile-restricted"):sec.isavailable||tile.addClass("tile-restricted"),sec.isclickable&&!tile.hasClass("tile-clickable")?tile.addClass("tile-clickable"):!sec.isclickable&&tile.hasClass("tile-clickable")&&tile.removeClass("tile-clickable"),sec.iscomplete?tile.addClass("is-complete"):tile.removeClass("is-complete"),setProgressIndicator(sec.sectionnum,sec.numcomplete,sec.numoutof);const availabilityInfoDiv=tile.find(Selector_availabilityinfo);availabilityInfoDiv.length>0&&sec.isavailable&&!sec.availabilitymessage?availabilityInfoDiv.fadeOut():!sec.isavailable&&sec.availabilitymessage&&(availabilityInfoDiv.length>0?(availabilityInfoDiv.html="NEW"+sec.availabilitymessage,availabilityInfoDiv.fadeIn()):Templates.render("format_tiles/availability_info",{availabilitymessage:sec.availabilitymessage,visible:!0}).done((function(html){$("tile-"+sec.section).find(".availabilityinfo").replaceWith(html)})))}})),setProgressIndicator(0,overallcomplete,overalloutof)};return{init:function(courseIdInit){courseId=courseIdInit,$(document).ready((function(){var loadingString="...";str.get_strings([{key:"loading",component:"format_tiles"}]).done((function(s){loadingString=s[0]+"  ..."})),$("body").on("click",Selector_toggleCompletionSubtile,(function(e){const currentTarget=$(e.currentTarget),section=currentTarget.closest("li.section");currentTarget.replaceWith('<span class="completionspinner spinner-grow spinner-grow-sm text-secondary mt-2 mr-2" role="status"><span class="sr-only">'+loadingString+"</span></span>");const cmId=parseInt(currentTarget.data("cmid"));if(ajax.call([{methodname:"core_completion_update_activity_completion_status_manually",args:{cmid:cmId,completed:1!==currentTarget.data("complete")}}])[0].done((res=>{!0===res.status&&triggerCompletionChangedEvent(section.data("section"),cmId)})),0!==currentTarget.closest(".embed-module-buttons").length){const cmId=currentTarget.data("cmid"),sectionNum=$("li#module-"+cmId).closest(Selector_section).data("section");triggerCompletionChangedEvent(sectionNum,cmId?parseInt(cmId):0)}}));var pageContent=$("#page-content");0===pageContent.length&&(pageContent=$("#region-main")),$("li.section a").on("click",(function(e){const target=$(e.target);if(target.attr("onclick")&&0===target.attr("onclick").indexOf("window.open")){const cm=target.closest("li.activity");if(cm.hasClass("completion-view")){const section=target.closest("li.section").data("section");triggerCompletionChangedEvent(section,cm.data("cmid"))}}})),coreManualCompletion.init()}))},triggerCompletionChangedEvent:function(sectionNum,cmid){triggerCompletionChangedEvent(sectionNum,cmid)},updateTileInformation:function(sectionNumbers){try{void 0===(sectionNums=sectionNumbers)&&(sectionNums=$(Selector_tile).not(Selector_spacer).map(((i,t)=>$(t).data("section"))).toArray()),ajax.call([{methodname:"format_tiles_get_section_information",args:{courseid:courseId,sectionnums:sectionNums}}])[0].done((res=>{updateSectionsInfo(res.sections,res.overall.complete,res.overall.outof)})).fail((err=>{require(["core/log"],(function(log){log.debug("Failed to get section information to check completion status of section"),log.debug(err)}))}))}catch(err){require(["core/log"],(function(log){log.debug(err)}))}var sectionNums},updateSectionsInfo:function(sections,overallcomplete,overalloutof){updateSectionsInfo(sections,overallcomplete,overalloutof)}}}));

//# sourceMappingURL=completion.min.js.map