/**
 * Javascript Module to handle the icon picker dialogue for format_tiles
 * which the editing user uses to select an icon for a tile or the default icon
 * for all tiles in the course
 *
 * @module      format_tiles/icon_picker
 * @copyright   2018 David Watson {@link http://evolutioncode.uk}
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since       Moodle 3.3
 */
define("format_tiles/edit_icon_picker",["jquery","core/templates","core/ajax","core/str","core/notification","core/config"],(function($,Templates,ajax,str,Notification,config){var modalStored,stringStore={pickAnIcon:""},iconSet=[],recentPhotoSet=[],getAndStoreIconSet=function(courseId,callback){var photosPromises=ajax.call([{methodname:"format_tiles_get_icon_set",args:{courseid:courseId}}]);photosPromises[0].done((function(response){response.photos&&(recentPhotoSet=JSON.parse(response.photos));var icons=JSON.parse(response.icons);Object.keys(icons).forEach((function(icon){iconSet.push({filename:icon,displayname:icons[icon]})})),iconSet.length<=0&&require(["core/log"],(function(log){log.error("Error empty icon set"),log.debug(response)})),"function"==typeof callback&&callback();var photoNames=recentPhotoSet.map((function(photo){return photo.filename}));$("#iconpickerphotos").find(".photo").each((function(index,ph){ph=$(ph),-1===photoNames.indexOf(ph.data("filename"))&&ph.fadeOut(500)})),!0!==response.status&&require(["core/log"],(function(log){log.error("Non true status response when getting icon set"),log.debug(response)}))})),photosPromises[0].fail((function(response){require(["core/log"],(function(log){log.error("Fail when getting icon set"),log.debug(response)}))}))},getPhotoTileButtonUrl=function(courseId,sectionId){return config.wwwroot+"/course/format/tiles/editor/editimage.php?sectionid="+sectionId},setIcon=function(sectionId,sectionNum,icon,displayname,pageType,courseId,imageType,sourcecontextid,sourceitemid){var selectedIcon=$("#selectedicon");const onCoursePage=["section-view-tiles","course-view-tiles","course-view-section-tiles"].includes(pageType);var changeUiTilePhoto=function(jqueryObjToChange,imageUrl,imageType){var templateToRender="",templateParams={tileicon:icon,tileid:sectionNum,secid:sectionId,isediting:1};switch(imageType){case"tileicon":icon.match(/^number_[\d]{1,2}$/)?(templateToRender="tilenumber",templateParams.tilenumber=icon.match(/\d+/)[0]):templateToRender="tileicon";break;case"tilephoto":if(!imageUrl){templateParams.tileicon=$("#format-tiles-js-config").data("defaultcourseicon"),templateToRender="tileicon";break}templateToRender="tilebarphoto",templateParams.phototileurl=imageUrl,templateParams.phototileediturl=getPhotoTileButtonUrl(0,sectionId),templateParams.imagetype=imageType,jqueryObjToChange.closest(".tileiconcontainer").addClass("hasphoto"),setTimeout((function(){getAndStoreIconSet(courseId)}),3e3);break;case"draftfile":templateToRender="tilebarphoto",templateParams.phototileurl=imageUrl,templateParams.phototileediturl=getPhotoTileButtonUrl(0,sectionId),templateParams.imagetype=imageType;break;default:throw new Error("Invalid image type "+imageType)}var divToAnimate=onCoursePage?jqueryObjToChange:selectedIcon;divToAnimate.animate({opacity:0},500,(function(){Templates.render("format_tiles/"+templateToRender,templateParams).done((function(html){divToAnimate.html(html).animate({opacity:1},500)}))}))};$(".tooltip").tooltip("hide");var ajaxIconPickArgs={image:icon,courseid:courseId,sectionid:Number(void 0===sectionId?0:sectionId),imagetype:imageType,sourcecontextid:void 0===sourcecontextid?0:sourcecontextid,sourceitemid:void 0===sourceitemid?0:sourceitemid};ajax.call([{methodname:"format_tiles_set_image",args:ajaxIconPickArgs}])[0].done((function(response){if(!0===response.status){if(onCoursePage)changeUiTilePhoto($("#tileicon_"+sectionNum),response.imageurl,imageType),""===response.imageurl&&getAndStoreIconSet(courseId);else if("course-edit"===pageType){$("#id_defaulttileicon").val(icon),"tileicon"===imageType?Templates.renderPix("tileicon/"+icon,"format_tiles",displayname).done((function(newIcon){selectedIcon.html(newIcon)})):"tilephoto"===imageType&&changeUiTilePhoto($("#tileicon_"+sectionNum),response.imageurl,imageType)}}else require(["core/log"],(function(log){log.error("False response setting icon"),log.debug(response)}))})).fail((function(response){require(["core/log"],(function(log){log.error("Fail setting icon"),log.debug(response)}))}))},launchIconPicker=function(pageType,courseId,sectionId,section,allowPhotoTiles,documentationurl,maxNumberIcons){if("object"!=typeof modalStored){var renderModal=function(){Templates.render("format_tiles/icon_picker_modal_body",{icon_picker_icons:iconSet,showphotos:allowPhotoTiles,sectionnumber:section,showicons:!0,tilenumbers:Array.from({length:maxNumberIcons+1},((e,i)=>i)).filter((e=>e>0)),wwwroot:config.wwwroot,documentationurl:documentationurl}).done((function(iconsHTML){require(["core/modal_factory"],(function(modalFact){modalFact.create({type:modalFact.types.DEFAULT,title:stringStore.pickAnIcon,body:iconsHTML}).done((function(modal){modalStored=modal,modal.setLarge(),modal.show();var modalRoot=$(modal.root);modalRoot.attr("id","icon_picker_modal"),modalRoot.data("true-sectionid",sectionId),modalRoot.data("section",section),modalRoot.addClass("icon_picker_modal"),modalRoot.find("#tile-number-container-".concat(section)).addClass("suggested"),modalRoot.on("click",".pickericon",(function(e){var newIcon=$(e.currentTarget);setIcon(sectionId,section,newIcon.data("icon"),newIcon.attr("title"),pageType,courseId,"tileicon",newIcon.data("contextid"),newIcon.data("itemid")),modal.hide()})),modalRoot.on("input","input.iconsearch",(function(e){var searchText=e.currentTarget.value.toLowerCase();modalRoot.find(".pickericon").show(),searchText.length>=3&&modalRoot.find(".pickericon").filter((function(index,icon){return $(icon).data("original-title").toLowerCase().indexOf(searchText)<0})).hide()}));try{const pickerIcon=$(".pickericon:not(.tile-number)");"function"==typeof pickerIcon.tooltip&&pickerIcon.tooltip()}catch(err){require(["core/log"],(function(log){log.debug(err)}))}if(allowPhotoTiles){var url=getPhotoTileButtonUrl(0,sectionId);modalRoot.find("#phototilebtn").attr("href",url),$("#launch-photo-library").click((function(){0!==recentPhotoSet.length&&Templates.render("format_tiles/icon_picker_photos",{icon_picker_photos:recentPhotoSet,wwwroot:config.wwwroot}).done((function(photosHTML){!function(photosHTML,modalRoot,modal){var photoLibrary=$("#iconpickerphotos");photoLibrary.html(photosHTML);var doLast=[];photoLibrary.find(".photo").each((function(index,image){(image=$(image)).data("filesize")<2e5&&image.data("url")?setTimeout((function(){image.attr("style","background-image: url('".concat(image.data("url"),"');"))}),20*index):doLast.push(image),image.click((function(e){var clickedImage=$(e.currentTarget);setIcon(modalRoot.data("true-sectionid"),modalRoot.data("section"),clickedImage.data("filename"),clickedImage.data("filename"),pageType,courseId,clickedImage.data("imagetype"),clickedImage.data("contextid"),clickedImage.data("itemid")),modal.hide()}))})),setTimeout((function(){doLast.forEach((function(image){image.attr("src",image.data("url"))}))}),1e3)}(photosHTML,modalRoot,modal)}))}))}$(document).trigger("format-tiles-icon-picker-modal-created")}))}))}))};iconSet.length<=0?getAndStoreIconSet(courseId,renderModal):renderModal()}else{if(modalStored.root.data("true-sectionid",sectionId),modalStored.root.data("section",section),modalStored.root.off("click"),modalStored.root.find(".tile-number-container").removeClass("suggested"),modalStored.root.find("#tile-number-container-".concat(section)).addClass("suggested"),modalStored.root.on("click",".pickericon",(function(e){var newIcon=$(e.currentTarget);setIcon(sectionId,section,newIcon.data("icon"),newIcon.attr("title"),pageType,courseId,newIcon.data("imagetype"),newIcon.data("contextid"),newIcon.data("itemid")),modalStored.hide()})),allowPhotoTiles){var url=getPhotoTileButtonUrl(0,sectionId);modalStored.root.find("#phototilebtn").attr("href",url)}modalStored.show()}};return{init:function(courseId,pageType,allowPhotoTiles,documentationurl,maxNumberIcons){$(document).ready((function(){var stringKey=allowPhotoTiles?"picknewiconphoto":"picknewicon";str.get_string(stringKey,"format_tiles").done((function(pickAnIcon){stringStore.pickAnIcon=pickAnIcon})),getAndStoreIconSet(courseId);var pageContent=$("#page-content");0===pageContent.length&&(pageContent=$("#region-main")),pageContent.on("click",'[data-tiles-action="launch-tiles-icon-picker"]',(function(e){e.preventDefault();var clickedIcon=$(e.currentTarget);launchIconPicker(pageType,courseId,clickedIcon.data("true-sectionid"),clickedIcon.data("section"),allowPhotoTiles,documentationurl,maxNumberIcons)}))}))}}}));

//# sourceMappingURL=edit_icon_picker.min.js.map