<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

// This line protects the file from being accessed by a URL directly.
defined('MOODLE_INTERNAL') || die();

// CCN Theme Constants
$string['pluginname'] = 'Edumy';
$string['configtitle'] = 'Edumy settings';
$string['choosereadme'] = 'Edumy Premium Moodle Theme, Created by Cocoon.';
$string['ccn_settings_menu'] = 'Options';
$string['ccn_page_settings_menu'] = 'Page Settings';
// CCN Plugin Constants: Backend
$string['config_title'] = 'Title';
$string['config_title_desc'] = 'The main title to use for the item.';
$string['config_title_2'] = 'Title 2';
$string['config_subtitle'] = 'Subtitle';
$string['config_subtitle_desc'] = 'The subtitle to use for the item.';
$string['config_image'] = 'Image';
$string['config_button_link'] = 'Button link';
$string['config_button_text'] = 'Button text';
$string['config_button_target'] = 'Button target';
$string['config_button_type'] = 'Button type';
$string['config_arrow_link'] = 'Arrow link';
$string['config_link'] = 'Link (URL)';
$string['config_link_desc'] = 'The link to use for the item. For absolute URLs, include the http protocol.';
$string['config_body'] = 'Body';
$string['config_number'] = 'Number';
$string['config_text'] = 'Text';
$string['config_icon_class'] = 'Icon';
$string['config_icon_class_desc'] = 'Select the icon to use for the item.';
$string['config_visibility'] = 'Visibility';
$string['config_visibility_desc'] = 'Configure the visibility for the item.';
$string['config_feature_1'] = 'Feature 1';
$string['config_feature_2'] = 'Feature 2';
$string['config_feature_3'] = 'Feature 3';
$string['config_feature_4'] = 'Feature 4';
$string['config_prev_1'] = 'Previous arrow (line 1)';
$string['config_prev_2'] = 'Previous arrow (line 2)';
$string['config_next_1'] = 'Next arrow (line 1)';
$string['config_next_2'] = 'Next arrow (line 2)';
$string['config_footer_text'] = 'Footer text';
$string['config_items'] = 'Items';
$string['config_item'] = 'Item ';
$string['config_date'] = 'Date';
$string['config_location'] = 'Location';
$string['config_time'] = 'Time';
$string['config_zoom'] = 'Zoom';
$string['config_size'] = 'Size';
$string['config_columns'] = 'Columns';
$string['config_end_date'] = 'End date';
$string['config_users'] = 'Users';
$string['cocoon_block_settings'] = '[Cocoon] Advanced block settings';
$string['cocoon_carousel_settings'] = '[Cocoon] Slider settings';
$string['config_ccn_carousel_autoplay'] = 'Autoplay';
$string['config_ccn_carousel_autoplay_timeout'] = 'Autoplay: Timing';
$string['config_ccn_carousel_speed'] = 'Autoplay: Speed';
$string['config_ccn_carousel_autoplay_pause'] = 'Autoplay: Pause on hover';
$string['config_ccn_carousel_loop'] = 'Loop';
$string['config_ccn_carousel_lazyload'] = 'Lazyload images';
$string['config_ccn_carousel_animateout'] = 'Animate out';
$string['config_ccn_carousel_animatein'] = 'Animate in';
$string['config_ccn_margin_top'] = 'Margin top';
$string['config_ccn_margin_bottom'] = 'Margin bottom';
$string['config_ccn_padding_top'] = 'Padding top';
$string['config_ccn_padding_bottom'] = 'Padding bottom';
$string['config_ccn_css_class'] = 'Custom CSS Class';
$string['config_updated'] = 'Updated';
$string['config_rating'] = 'Rating';
$string['config_description'] = 'Description';
$string['config_enrolments'] = 'Enrolments';
$string['config_newsitems'] = 'News items';
$string['config_price'] = 'Price';
$string['config_enrol_btn'] = 'Enrol button';
$string['config_enrol_btn_text'] = 'Enrol button text';
$string['config_autoplay'] = 'Autoplay';
$string['config_speed'] = 'Speed';
$string['config_loop'] = 'Loop';
$string['config_teacher'] = 'Teacher';
$string['config_style'] = 'Style';
$string['config_recaptcha'] = 'reCAPTCHA';
$string['config_yt'] = 'YouTube Video ID';
$string['config_button_link_or_video'] = 'The URL for the button. Alternatively, enter a YouTube or Vimeo URL to enable video overlay.';
$string['config_color'] = 'Color';
$string['config_color_desc'] = 'Select the color to use for the item.';
$string['config_line_break'] = 'Line break';
$string['config_overrides'] = 'Override values';
$string['config_body_type'] = 'Body type';
$string['config_body_plain'] = 'Body (plain text)';
$string['config_body_html'] = 'Body (HTML editor)';
$string['config_prev'] = 'Previous';
$string['config_next'] = 'Next';
$string['config_arrow_style'] = 'Arrow style';
$string['config_hover_text'] = 'Hover text';
$string['config_hover_accent'] = 'Hover accent';
$string['select_from_dropdown'] = 'Please select an item from the dropdown below.';
$string['select_from_dropdown_multiple'] = 'Please select multiple items from the dropdown below.';
$string['config_featured_text'] = 'Featured text';
$string['config_features'] = 'Features';
$string['config_features_help'] = 'The features for the price table. Enter one feature per line.';
$string['config_group_courses_filter'] = 'Enable filtering';
$string['config_form'] = 'Form settings';
$string['config_number_after'] = 'Number suffix';
$string['block_styles'] = '[Cocoon] Block styles';
$string['on_hover'] = ' (on hover)';
$string['border_radius'] = ' border radius';
$string['config_countdown_date'] = 'Countdown Date';
$string['config_color_overlay'] = 'Overlay';
$string['config_color_hover'] = 'Hover';
$string['config_color_bg'] = 'Background';
$string['config_color_title'] = 'Title';
$string['config_color_subtitle'] = 'Subtitle';
$string['config_color_body'] = 'Body';
$string['config_color_course_card'] = 'Course card';
$string['config_color_course_title'] = 'Course title';
$string['config_color_course_price'] = 'Course price';
$string['config_color_course_enrol_btn'] = 'Course enrol button';
$string['config_color_icon'] = 'Icon';
$string['config_color_text'] = 'Text';
$string['config_color_btn'] = 'Button';
$string['config_color_button'] = 'Button';
$string['config_video'] = 'Video';
$string['config_countdown_date'] = 'Countdown date';
$string['config_button'] = 'Button';
$string['config_color_panel_bg'] = 'Panel background';
$string['config_color_panel_title'] = 'Panel title';
$string['config_color_panel_subtitle'] = 'Panel subtitle';
$string['config_color_panel_body'] = 'Panel body';
$string['config_form_title'] = 'Form title';
$string['config_color_item_title'] = 'Item title';
$string['config_color_item_body'] = 'Item body';
$string['config_c_ccn_ic'] = 'Item background';
$string['config_c_ccn_i'] = 'Icon';
$string['config_c_ccn_it'] = 'Item title';
$string['config_c_ccn_ib'] = 'Item body';
$string['config_c_ccn_ibt'] = 'Item button';
$string['config_child_categories'] = 'Show child categories';
$string['config_box_shadow'] = 'Box shadow';

// CCN Plugin Constants: Frontend
$string['search_string'] = 'Search for the software or skills you want to learn';
$string['updated'] = 'Updated';
$string['events'] = 'Events';
$string['event'] = 'Event';
$string['rated_by'] ='{$a} student ratings';
$string['rate_course'] ='Submit rating';
$string['number_of_courses'] ='Over {$a} courses';
$string['number_of_subcategories'] ='Over {$a} categories';
$string['categories'] = 'Categories';
$string['hidden'] ='Hidden';
$string['back_to_course'] ='Back to Course';
$string['back_to_site'] ='Back to Site';
$string['course_navigation'] ='Course Navigation';
$string['rating_success'] ='Rating complete!';
// CCN Dashboard Constants
$string['messages_desc'] = 'Communicate';
$string['messages_title'] = 'Messages';
$string['profile_desc'] = 'Your Profile';
$string['profile_title'] = 'Profile';
$string['preferences_desc'] = 'Preferences';
$string['preferences_title'] = 'Settings';
$string['grades_desc'] = 'Performance';
$string['grades_title'] = 'Grades';
// CCN Regions
$string['region-side-pre'] = 'Sidebar right';
$string['region-left'] = 'Sidebar left';
$string['region-user-notif'] = 'User notifications';
$string['region-user-messages'] = 'User messages';
$string['region-fullwidth-top'] = 'Fullwidth top';
$string['region-fullwidth-bottom'] = 'Fullwidth bottom';
$string['region-above-content'] = 'Above content';
$string['region-below-content'] = 'Below content';
$string['region-login'] = 'Modal login';
$string['region-register'] = 'Modal register';
$string['region-search'] = 'Modal search';
$string['region-library-list'] = 'Library list';
$string['region-navbar'] = 'Navbar';
// CCN Theme Settings
$string['headerlogo1'] = 'Header logo (Light)';
$string['headerlogo1_desc'] = 'The light variant of your website logo.';
$string['headerlogo2'] = 'Header logo (Dark)';
$string['headerlogo2_desc'] = 'The dark variant of your website logo.';
$string['headerlogo3'] = 'Header logo (Large)';
$string['headerlogo3_desc'] = 'The large variant of your website logo.';
$string['headerlogo4'] = 'Header logo (Login page)';
$string['headerlogo4_desc'] = '(Optional) Upload a logo for the login page. If empty, the default logo (Header Logo Light) will be used.';
$string['headerlogo_mobile'] = 'Header logo (Mobile)';
$string['headerlogo_mobile_desc'] = 'The mobile variant of your website logo (optional).';
$string['footerlogo1'] = 'Footer logo';
$string['footerlogo1_desc'] = 'The footer logo for your website.';
$string['cocoon_copyright'] = 'Copyright notice';
$string['cocoon_copyright_desc'] = 'The copyright notice for your website.';
$string['social_settings'] = 'Social';
$string['cocoon_facebook_url'] = 'Facebook URL';
$string['cocoon_facebook_url_desc'] = 'The link to your company\'s Facebook profile.';
$string['cocoon_twitter_url'] = 'Twitter URL';
$string['cocoon_twitter_url_desc'] = 'The link to your company\'s Twitter profile.';
$string['cocoon_instagram_url'] = 'Instagram URL';
$string['cocoon_instagram_url_desc'] = 'The link to your company\'s Instagram profile.';
$string['cocoon_dribbble_url'] = 'Dribbble URL';
$string['cocoon_dribbble_url_desc'] = 'The link to your company\'s Dribbble profile.';
$string['cocoon_pinterest_url'] = 'Pinterest URL';
$string['cocoon_pinterest_url_desc'] = 'The link to your company\'s Pinterest profile.';
$string['cocoon_google_url'] = 'Google URL';
$string['cocoon_google_url_desc'] = 'The link to your company\'s Google profile.';
$string['cocoon_youtube_url'] = 'YouTube URL';
$string['cocoon_youtube_url_desc'] = 'The link to your company\'s YouTube profile.';
$string['cocoon_vk_url'] = 'VK URL';
$string['cocoon_vk_url_desc'] = 'The link to your company\'s VK profile.';
$string['cocoon_500px_url'] = '500px URL';
$string['cocoon_500px_url_desc'] = 'The link to your company\'s 500px profile.';
$string['cocoon_behance_url'] = 'Behance URL';
$string['cocoon_behance_url_desc'] = 'The link to your company\'s Behance profile.';
$string['cocoon_digg_url'] = 'Digg URL';
$string['cocoon_digg_url_desc'] = 'The link to your company\'s Digg profile.';
$string['cocoon_flickr_url'] = 'Flickr URL';
$string['cocoon_flickr_url_desc'] = 'The link to your company\'s Flickr profile.';
$string['cocoon_foursquare_url'] = 'Foursquare URL';
$string['cocoon_foursquare_url_desc'] = 'The link to your company\'s Foursquare profile.';
$string['cocoon_linkedin_url'] = 'LinkedIn URL';
$string['cocoon_linkedin_url_desc'] = 'The link to your company\'s LinkedIn profile.';
$string['cocoon_medium_url'] = 'Medium URL';
$string['cocoon_medium_url_desc'] = 'The link to your company\'s Medium profile.';
$string['cocoon_meetup_url'] = 'Meetup URL';
$string['cocoon_meetup_url_desc'] = 'The link to your company\'s Meetup profile.';
$string['cocoon_snapchat_url'] = 'Snapchat URL';
$string['cocoon_snapchat_url_desc'] = 'The link to your company\'s Snapchat profile.';
$string['cocoon_tumblr_url'] = 'Tumblr URL';
$string['cocoon_tumblr_url_desc'] = 'The link to your company\'s Tumblr profile.';
$string['cocoon_vimeo_url'] = 'Vimeo URL';
$string['cocoon_vimeo_url_desc'] = 'The link to your company\'s Vimeo profile.';
$string['cocoon_wechat_url'] = 'WeChat URL';
$string['cocoon_wechat_url_desc'] = 'The link to your company\'s WeChat profile.';
$string['cocoon_whatsapp_url'] = 'WhatsApp URL';
$string['cocoon_whatsapp_url_desc'] = 'The link to your company\'s WhatsApp profile.';
$string['cocoon_wordpress_url'] = 'WordPress URL';
$string['cocoon_wordpress_url_desc'] = 'The link to your company\'s WordPress profile.';
$string['cocoon_weibo_url'] = 'Weibo URL';
$string['cocoon_weibo_url_desc'] = 'The link to your company\'s Weibo profile.';
$string['cocoon_telegram_url'] = 'Telegram URL';
$string['cocoon_telegram_url_desc'] = 'The link to your company\'s Telegram profile.';
$string['cocoon_moodle_url'] = 'Moodle URL';
$string['cocoon_moodle_url_desc'] = 'The link to your company\'s Moodle profile.';
$string['cocoon_amazon_url'] = 'Amazon URL';
$string['cocoon_amazon_url_desc'] = 'The link to your company\'s Amazon profile.';
$string['cocoon_slideshare_url'] = 'SlideShare URL';
$string['cocoon_slideshare_url_desc'] = 'The link to your company\'s SlideShare profile.';
$string['cocoon_soundcloud_url'] = 'Soundcloud URL';
$string['cocoon_soundcloud_url_desc'] = 'The link to your company\'s Soundcloud profile.';
$string['cocoon_leanpub_url'] = 'Leanpub URL';
$string['cocoon_leanpub_url_desc'] = 'The link to your company\'s Leanpub profile.';
$string['cocoon_xing_url'] = 'Xing URL';
$string['cocoon_xing_url_desc'] = 'The link to your company\'s Xing profile.';
$string['cocoon_bitcoin_url'] = 'Bitcoin URL';
$string['cocoon_bitcoin_url_desc'] = 'The link to your company\'s Bitcoin profile.';
$string['cocoon_twitch_url'] = 'Twitch URL';
$string['cocoon_twitch_url_desc'] = 'The link to your company\'s Twitch profile.';
$string['cocoon_github_url'] = 'Github URL';
$string['cocoon_github_url_desc'] = 'The link to your company\'s Github profile.';
$string['cocoon_gitlab_url'] = 'Gitlab URL';
$string['cocoon_gitlab_url_desc'] = 'The link to your company\'s Gitlab profile.';
$string['cocoon_forumbee_url'] = 'Forumbee URL';
$string['cocoon_forumbee_url_desc'] = 'The link to your company\'s Forumbee profile.';
$string['cocoon_trello_url'] = 'Trello URL';
$string['cocoon_trello_url_desc'] = 'The link to your company\'s Trello profile.';
$string['cocoon_weixin_url'] = 'Weixin URL';
$string['cocoon_weixin_url_desc'] = 'The link to your company\'s Weixin profile.';
$string['cocoon_slack_url'] = 'Slack URL';
$string['cocoon_slack_url_desc'] = 'The link to your company\'s Slack profile.';
$string['header_settings'] = 'Header';
$string['headertype'] = 'Header style';
$string['headertype_desc'] = 'Select the header style for the website. Note that some fields below only apply to certain header styles.';
$string['email_address'] = 'Email address';
$string['email_address_desc'] = 'Your company\'s email address.';
$string['phone'] = 'Telephone';
$string['phone_desc'] = 'Your company\'s telephone number.';
$string['cta_text'] = 'Call-to-action text';
$string['cta_text_desc'] = 'The call-to-action text that should be displayed.';
$string['cta_link'] = 'Call-to-action link';
$string['cta_link_desc'] = 'The link for the call-to-action.';
$string['cta_icon'] = 'Call-to-action icon';
$string['cta_icon_desc'] = 'The icon for the call-to-action.';
$string['footer_settings'] = 'Footer';
$string['footertype'] = 'Footer style';
$string['footertype_desc'] = 'Select the footer style for the website. Note that some fields below only apply to certain footer styles.';
$string['footer_col_1'] = 'Footer column 1';
$string['footer_col_2'] = 'Footer column 2';
$string['footer_col_3'] = 'Footer column 3';
$string['footer_col_4'] = 'Footer column 4';
$string['footer_col_5'] = 'Footer column 5';
$string['footer_col_title'] = 'Column title';
$string['footer_col_title_desc'] = 'The title for the footer column.';
$string['footer_col_body'] = 'Column body';
$string['footer_col_body_desc'] = 'The body for the footer column. HTML is allowed.';
$string['footer_menu'] = 'Footer menu';
$string['footer_menu_desc'] = 'The content for the footer menu. HTML is allowed.';
$string['general_settings'] = 'General';
$string['blogstyle'] = 'Blog style';
$string['blogstyle_desc'] = 'The style for the website blog.';
$string['courseliststyle'] = 'Course list style';
$string['courseliststyle_desc'] = 'The style for the course category view.';
$string['optimization_settings'] = 'Optimization';
$string['lazy_loading'] = 'Image lazy loading';
$string['lazy_loading_desc'] = 'Lazy loading speeds up your website by only loading images once they scroll into view. Edumy 2.5 and above introduces experimental lazy loading in some areas of your Moodle website.';
$string['advanced_settings'] = 'Advanced';
$string['custom_css'] = 'Custom CSS';
$string['custom_css_desc'] = 'Your custom CSS, loaded only on the front-end.';
$string['custom_css_dashboard'] = 'Custom CSS (Dashboard)';
$string['custom_css_dashboard_desc'] = 'Your custom CSS, loaded only on the dashboard.';
$string['custom_css_h5p'] = 'Custom CSS (H5P)';
$string['custom_css_h5p_desc'] = 'Your custom CSS, loaded only within H5P activities.';
$string['custom_js'] = 'Custom JavaScript';
$string['custom_js_desc'] = 'Your custom JavaScript, loaded only on the front-end.';
$string['custom_js_dashboard'] = 'Custom JavaScript (Dashboard)';
$string['custom_js_dashboard_desc'] = 'Your custom JavaScript, loaded only on the dashboard.';
$string['user_settings'] = 'Users';
$string['user_custf_other'] = '"Other fields" placement';
$string['user_custf_other_desc'] = 'Customize the placement of "Other fields" custom profile fields on user edit pages.';
$string['heading_bg'] = 'Page heading background';
$string['heading_bg_desc'] = 'The background image for the page heading/breadcrumb hero.';
$string['login_bg'] = 'Login background';
$string['login_bg_desc'] = 'The background image for the login & registration page.';
$string['logotype'] = 'Logotype visibility';
$string['logotype_desc'] = 'Display the logotype beside the logo image?';
$string['logo_image'] = 'Logo image visibility';
$string['logo_image_desc'] = 'Display the logo image?';
$string['logotype_footer'] = 'Footer logotype visibility';
$string['logotype_footer_desc'] = 'Display the logotype beside the footer logo image?';
$string['logo_image_footer'] = 'Footer logo image visibility';
$string['logo_image_footer_desc'] = 'Display the footer logo image?';
$string['color_settings'] = 'Color';
$string['color_settings_gradient'] = 'Gradient';
$string['color_gradient_start'] = 'Gradient start';
$string['color_gradient_start_desc'] = 'The color for the start of the gradient.';
$string['color_gradient_end'] = 'Gradient end';
$string['color_gradient_end_desc'] = 'The color for the end of the gradient.';
$string['color_settings_main'] = 'Common colors';
$string['color_primary'] = 'Primary color';
$string['color_primary_desc'] = 'The primary color used throughout the site.';
$string['color_primary_alternate'] = 'Primary color (alternate)';
$string['color_primary_alternate_desc'] = 'The alternate primary color used throughout the site.';
$string['color_secondary'] = 'Secondary color';
$string['color_secondary_desc'] = 'The secondary color used throughout the site.';
$string['color_accent'] = 'Accent color';
$string['color_accent_desc'] = 'The accent color used to highlight specific elements.';
$string['color_accent_2'] = 'Second accent color';
$string['color_accent_2_desc'] = 'The second accent color used to highlight specific elements.';
$string['color_accent_3'] = 'Third accent color';
$string['color_accent_3_desc'] = 'The third accent color used to highlight specific elements.';
$string['color_accent_4'] = 'Fourth accent color';
$string['color_accent_4_desc'] = 'The fourth accent color used to highlight specific elements.';
$string['color_settings_header_style_2'] = 'Header colors (style 2)';
$string['color_settings_header_style_3'] = 'Header colors (style 3)';
$string['color_settings_header_style_4'] = 'Header colors (style 4)';
$string['color_settings_header_style_5'] = 'Header colors (style 5)';
$string['color_settings_header_style_6'] = 'Header colors (style 6)';
$string['color_header_color'] = 'Header color';
$string['color_header_color_desc'] = 'The color for the header.';
$string['color_header_color_top'] = 'Header top';
$string['color_header_color_top_desc'] = 'The color for the header top.';
$string['color_header_color_bottom'] = 'Header bottom';
$string['color_header_color_bottom_desc'] = 'The color for the header bottom.';
$string['color_settings_footer_style_1'] = 'Footer colors (style 1)';
$string['color_settings_footer_style_2'] = 'Footer colors (style 2)';
$string['color_settings_footer_style_3'] = 'Footer colors (style 3)';
$string['color_settings_footer_style_5'] = 'Footer colors (style 5)';
$string['color_settings_footer_style_6'] = 'Footer colors (style 6)';
$string['color_settings_footer_style_7'] = 'Footer colors (style 7)';
$string['color_footer_color_top'] = 'Footer top';
$string['color_footer_color_top_desc'] = 'The color for the footer top.';
$string['color_footer_color_middle'] = 'Footer middle';
$string['color_footer_color_middle_desc'] = 'The color for the footer middle.';
$string['color_footer_color_bottom'] = 'Footer bottom';
$string['color_footer_color_bottom_desc'] = 'The color for the footer bottom.';
$string['color_footer_color'] = 'Footer color';
$string['color_footer_color_desc'] = 'The color for the footer.';
$string['gmaps_key'] = 'Google Maps API Key';
$string['gmaps_key_desc'] = 'Your Google Maps API Key';
$string['favicon'] = 'Favicon';
$string['favicon_desc'] = 'The favicon for the website. Recommended size is 16 x 16px.';
$string['library_list'] = 'Library list';
$string['library_list_desc'] = 'Display a library list (list of course categories) in the header.';
$string['logo_settings'] = 'Logo';
$string['header_logos'] = 'Header logos';
$string['footer_logos'] = 'Footer logos';
$string['header_search'] = 'Header search';
$string['header_search_desc'] = 'Settings for the search functionality in the header.';
$string['header_login'] = 'Header login';
$string['header_main_menu'] = 'Main menu';
$string['header_main_menu_desc'] = 'Visibility of the main navigation menu links.';
$string['disable_primary_nav'] = 'Disable primary navigation';
$string['disable_primary_nav_desc'] = 'Disable Moodle core primary navigation? This will remove "Home", "Dashboard", "My Courses", and "Site administration" links from the main menu bar.';
$string['header_login_desc'] = 'Settings for the login functionality in the header.';
$string['back_to_top'] = 'Back to Top';
$string['back_to_top_desc'] = 'Show or hide the back-to-top button on the frontend.';
$string['language_menu'] = 'Language menu';
$string['language_menu_desc'] = 'Settings for the language menu.';
$string['blog_post_author'] = 'Blog post author';
$string['blog_post_author_desc'] = 'Show or hide the author name on blog posts. This setting controls the blog listing page, individual blog posts, and all [Cocoon] blocks.';
$string['blog_post_date'] = 'Blog post date';
$string['blog_post_date_desc'] = 'Show or hide the date on blog posts. This setting controls the blog listing page, individual blog posts, and all [Cocoon] blocks.';
$string['headertype_settings'] = 'Header style settings';
$string['headertype_settings_desc'] = 'Select whether the header style should apply only to the frontpage, or to all pages throughout the site.';
$string['logo_image_width'] = 'Logo image width';
$string['logo_image_width_desc'] = 'The width in pixels for the header logo. Enter the numercial value only, and do not include "px".';
$string['logo_image_height'] = 'Logo image height';
$string['logo_image_height_desc'] = 'The height in pixels for the header logo. Enter the numercial value only, and do not include "px".';
$string['logo_image_width_footer'] = 'Footer logo image width';
$string['logo_image_width_footer_desc'] = 'The width in pixels for the footer logo. Enter the numercial value only, and do not include "px".';
$string['logo_image_height_footer'] = 'Footer logo image height';
$string['logo_image_height_footer_desc'] = 'The height in pixels for the footer logo. Enter the numercial value only, and do not include "px".';
$string['preloader_image'] = 'Preloader image';
$string['preloader_image_desc'] = 'The image to use for the preloader.';
$string['dashboard_settings'] = 'Dashboard';
$string['dashboard_settings_long'] = 'Dashboard settings';
$string['dashboard_icons'] = 'Dashboard icons';
$string['dashboard_icons_visibility'] = 'Dashboard icons visibility';
$string['dashboard_icons_visibility_desc'] = 'Show or hide the icons in the user dashboard.';
$string['icon_1'] = 'Icon 1';
$string['icon_2'] = 'Icon 2';
$string['icon_3'] = 'Icon 3';
$string['icon_4'] = 'Icon 4';
$string['dashboard_sticky_header'] = 'Sticky header';
$string['dashboard_sticky_header_desc'] = 'Settings for the dashboard sticky header.';
$string['dashboard_left_drawer'] = 'Dashboard left drawer';
$string['dashboard_left_drawer_desc'] = 'Visibility settings for the left navigation drawer in the Dashboard. Use the default Start menu, or use custom blocks instead. Alternatively, disable the left drawer entirely.';
$string['dashboard_sticky_drawer'] = 'Sticky left drawer';
$string['dashboard_sticky_drawer_desc'] = 'Keep the dashboard left drawer stuck to the screen, or scroll with the page.';
$string['primary_font'] = 'Primary font';
$string['primary_font_desc'] = 'The primary font used throughout the website.';
$string['secondary_font'] = 'Secondary font';
$string['secondary_font_desc'] = 'The secondary font used throughout the website.';
$string['color_tertiary'] = 'Tertiary color';
$string['color_tertiary_desc'] = 'The tertiary color used throughout the site.';
$string['color_parallax'] = 'Parallax color';
$string['color_parallax_desc'] = 'The parallax color used throughout the website.';
$string['course_settings'] = 'Course';
$string['course_settings_topics_format'] = 'Topics format';
$string['topics_format_collapsible'] = 'Collapsible settings';
$string['topics_format_collapsible_desc'] = 'Settings for the collapsible topics format.';
$string['breadcrumb_settings'] = 'Breadcrumb';
$string['breadcrumb_style'] = 'Breadcrumb style';
$string['breadcrumb_style_desc'] = 'The style of the inner page breadcrumb.';
$string['breadcrumb_caps'] = 'Breadcrumb capitalization';
$string['breadcrumb_caps_desc'] = 'The capitalization of the breadcrumb trail.';
$string['breadcrumb_clip'] = 'Clip breadcrumb text';
$string['breadcrumb_clip_desc'] = 'Configure the clipping or reducing of long text in the breadcrumb.';
$string['breadcrumb_title'] = 'Breadcrumb title';
$string['breadcrumb_title_desc'] = 'Display the breadcrumb title.';
$string['breadcrumb_trail'] = 'Breadcrumb navigation trail';
$string['breadcrumb_trail_desc'] = 'Display the breadcrumb navigation trail.';
$string['preloader_settings'] = 'Preloader';
$string['preloader_duration'] = 'Preloader duration';
$string['preloader_duration_desc'] = 'The length of time to display the preloader. It is highly recommended to leave this as the default. To accelarate loading time, we suggest compressing images prior to uploading.';
$string['course_content_enroled_only'] = 'Course Content access';
$string['course_content_enroled_only_desc'] = '(Topics format only) - Choose whether to display course content to all users, or only those enroled in the course. This is helpful you want to allow guest access to course pages, but hide the list of course content, topics, sections, and activity names from unenroled users.';
$string['social_target'] = 'Social URL window target';
$string['social_target_desc'] = 'Determine whether social URLs should open on the same page or in a new window.';
$string['coursecat_modified'] = 'Last updated';
$string['coursecat_modified_desc'] = 'Show the date that the course/category was last updated.';
$string['coursecat_enrolments'] = 'Course enrolments';
$string['coursecat_enrolments_desc'] = 'Show the number of students enroled in a course.';
$string['coursecat_announcements'] = 'Course news items';
$string['coursecat_announcements_desc'] = 'Show the number of course announcements in a course.';
$string['coursecat_prices'] = 'Course price';
$string['coursecat_prices_desc'] = 'Show course prices in category lists and blocks.';
$string['coursecat_settings'] = 'Course category settings';
$string['single_course_settings'] = 'Single course settings';
$string['course_single_style'] = 'Single course style';
$string['course_single_style_desc'] = 'Select the style to use on single courses.';
$string['course_start_date'] = 'Course start date';
$string['course_start_date_desc'] = 'Display the start date in single course pages, above the course content.';
$string['course_category'] = 'Course category';
$string['course_category_desc'] = 'Display the category in single course pages, above the course content.';
$string['seo'] = 'SEO';
$string['meta_description'] = 'Meta description';
$string['meta_description_desc'] = 'The meta description for your Moodle site.';
$string['meta_abstract'] = 'Meta abstract';
$string['meta_abstract_desc'] = 'The meta abstract for your Moodle site (the abstract tag is sometimes used for archiving of web pages or by educational establishments).';
$string['meta_keywords'] = 'Meta keywords';
$string['meta_keywords_desc'] = 'The meta keywords for your Moodle site.';
$string['incourse_layout'] = 'In course layout';
$string['incourse_layout_desc'] = 'The layout that should be used when a user is within a course (eg accessing individual course activities, resources, or content). Custom blocks may not be displayed when using the Dashboard layout.';
$string['coursemainpage_layout'] = 'Course main page layout';
$string['coursemainpage_layout_desc'] = 'The layout that should be used when a user is on a course main page. Custom blocks may not be displayed when using the Dashboard layout.';
$string['singlecourse_blocks'] = 'Course block visibility';
$string['singlecourse_blocks_desc'] = 'Choose whether to display blocks added to courses on all pages of the course, or only on the main course page. Use this setting to prevent blocks from appearing on similar course pages (such as the Participants page and User pages). This setting affects all blocks added to courses, not just Cocoon blocks.';
$string['user_profile_layout'] = 'User profile layout';
$string['user_profile_layout_desc'] = 'The layout that should be used for user profiles.';
$string['dashboard_layout'] = 'Dashboard layout';
$string['dashboard_layout_desc'] = 'The layout that should be used for dashboard pages.';
$string['login_layout'] = 'Login page layout';
$string['login_layout_desc'] = 'The layout that is used for login and registration pages.';
$string['edumy_homepage'] = 'Frontpage';
$string['edumy_homepage_desc'] = 'Settings for the frontpage layout';
$string['edumy_homepage_core'] = 'Frontpage sections';
$string['edumy_homepage_core_desc'] = 'Display Moodle core sections on the frontpage?';
$string['login_layout_desc'] = 'The layout that is used for login and registration pages.';
$string['layout_settings'] = 'Layout';
$string['edumy_focus'] = 'Edumy Focus';
$string['edumy_focus_desc'] = 'Settings for Edumy Focus layouts.';
$string['edumy_focus_sidebar'] = 'Display navigation sidebar?';
$string['edumy_focus_sidebar_desc'] = 'Choose whether to display the activity sidebar in Edumy Focus layouts.';
$string['course_enrolment_payment'] = 'Course enrolment payment';
$string['course_enrolment_payment_desc'] = 'Settings for course enrolment preferences. Do all courses require payment, or are some free? This setting dictates how course enrolment will work and be displayed.';
$string['dashboard_tablet_1'] = 'Dashboard tablet 1';
$string['dashboard_tablet_2'] = 'Dashboard tablet 2';
$string['dashboard_tablet_3'] = 'Dashboard tablet 3';
$string['dashboard_tablet_4'] = 'Dashboard tablet 4';
$string['general_course_settings'] = 'General course settings';
$string['course_ratings'] = 'Course ratings';
$string['course_ratings_desc'] = 'Settings for course star ratings.';
$string['font_settings'] = 'Fonts';
$string['upload_font_woff'] = 'Font WOFF';
$string['upload_font_woff_desc'] = 'Upload the WOFF file for the custom font. Optional, but recommended.';
$string['upload_font_woff2_desc'] = 'Upload the WOFF2 file for the custom font. Optional, but recommended.';
$string['upload_font_ttf_desc'] = 'Upload the TTF file for the custom font. Optional, but recommended.';
$string['upload_font_eot_desc'] = 'Upload the EOT file for the custom font. Optional, but recommended.';
$string['upload_font_svg_desc'] = 'Upload the SVG file for the custom font. Optional, but recommended.';
$string['upload_font_woff2'] = 'Font WOFF2';
$string['upload_font_ttf'] = 'Font TTF';
$string['upload_font_eot'] = 'Font EOT';
$string['upload_font_svg'] = 'Font SVG';
$string['google_fonts'] = 'Google fonts';
$string['custom_font_primary'] = 'Custom font (primary)';
$string['custom_font_secondary'] = 'Custom font (secondary)';
$string['dashboard_header'] = 'Dashboard header';
$string['dashboard_header_desc'] = 'Configure the appearance of the dashboard header.';
$string['navigation_icon'] = 'Navigation icon';
$string['notification_icon'] = 'Notification icon';
$string['messages_icon'] = 'Messages icon';
$string['dark_mode_icon'] = 'Night Learning icon';
$string['profile_icon'] = 'Profile dropdown';
$string['profile_icon_username'] = 'Username appearance';
$string['profile_icon_username_desc'] = 'The appearance of the username in the profile dropdown in the main navigation bar.';
$string['page_settings_controls'] = 'Page Settings button';
$string['page_settings_controls_desc'] = 'Moodle sometimes displays the "Page Settings" button for Students and Guests. Here you can prevent it from displaying for these users.';
$string['select'] = 'Select';
$string['course_price_format'] = 'Price format';
$string['course_price_format_desc'] = 'The format for which prices should be displayed throughout the site.';
$string['live_customizer'] = 'Live customizer';
$string['icons'] = 'Icons';
$string['icons_desc'] = 'Edumy includes 4 iconsets that provide a total of 3000 icons. If you prefer less icons, disable iconsets here. Before disabling iconsets, please make sure that no fields are using icons from the disabled sets.';
$string['iconset_desc'] = 'Load this iconset';
$string['iconset_edumy'] = 'Edumy icons';
$string['iconset_cocoon'] = 'Cocoon icons';
$string['iconset_fontawesome'] = 'FontAwesome icons';
$string['iconset_lineawesome'] = 'LineAwesome icons';
$string['order_receipts'] = 'Order receipts';
$string['address_line_1'] = 'Address line 1';
$string['address_line_2'] = 'Address line 2';
$string['address_line_3'] = 'Address line 3';
$string['address_line_1_desc'] = 'The first line of your address.';
$string['address_line_2_desc'] = 'The second line of your address.';
$string['address_line_3_desc'] = 'The third line of your address.';
$string['zip_code'] = 'ZIP Code';
$string['zip_code_desc'] = 'Your ZIP code';
$string['for_developers'] = 'For Developers';
$string['for_developers_desc'] = 'Settings provided for developers to aid in further extension of Edumy theme.';
$string['dev_expose_blocks'] = 'Expose blocks';
$string['dev_expose_blocks_desc'] = 'Make all custom Cocoon blocks available on all site pages, including the user dashboard and site administration.';
$string['course_settings_activities'] = 'Activity modules';
$string['quiz_layout'] = 'Quiz layout';
$string['quiz_layout_desc'] = 'The layout of the quiz activity.';
$string['logo_url'] = 'Logo URL';
$string['logo_url_desc'] = 'Override the logo URL in all Edumy headers and footers.';

// CCN Fixes
$string['allexcepthidden'] = 'All (except hidden)';

// Theme Edumy
$string['studentsiamteaching'] = 'Students I\'m teaching';
$string['coursesiamteaching'] = 'Courses I\'m teaching';
$string['coursesiamtaking'] = 'Courses I\'m taking';
$string['profileviews'] = 'My profile views';
$string['socialmedia'] = 'Social media';
$string['accessed'] = 'Accessed';
$string['last_accessed'] = 'last accessed';
$string['last_accessed_courses'] = 'Last Accessed Courses';
$string['select_no_cat'] = 'Please select number of categories.';
$string['navigation'] = 'Navigation';
$string['start'] = 'Start';
$string['login_welcome'] = 'Login to your account';
$string['login'] = 'Login';
$string['login_no_account'] = 'Don\'t have an account?';
$string['signup'] = 'Sign up!';
$string['search_courses'] = 'Search courses...';
$string['forgot_password'] = 'Forgot Password?';
$string['or'] = 'Or';
$string['login_register'] = 'Login/Register';
$string['your_name'] = 'Your name';
$string['your_name_requirements'] = 'Minimum 3 letters/spaces.';
$string['email_address'] = 'Email address';
$string['email_address_requirements'] = 'A real email address.';
$string['subject'] = 'Subject';
$string['subject_requirements'] = 'Minimum 5 characters.';
$string['message'] = 'Message';
$string['message_requirements'] = 'Minimum 5 characters.';
$string['send'] = 'Send';
$string['lectures'] = 'Lectures';
$string['quizzes'] = 'Quizzes';
$string['duration'] = 'Duration';
$string['skill_level'] = 'Skill level';
$string['language'] = 'Language';
$string['assessments'] = 'Assessments';
$string['last_updated'] = 'Last updated';
$string['share'] = 'Share';
$string['students_enrolled'] = 'students enrolled';
$string['topics'] = 'topics';
$string['see_more'] = 'See more';
$string['course_enrolment'] = 'Buy & Enrol Now';
$string['course_enrolment_free'] = 'Join & Enrol Now';
$string['course_free_access'] = 'Enrolment is Free';
$string['course_free'] = 'FREE';
$string['course_free_accent'] = '100%';
$string['course_free_to_join'] = 'to join';
$string['course_buy_access'] = 'Paid course entry';
$string['course_enrolled'] = 'You\'re enrolled';
$string['course_enrolled_text'] = 'You are currently enrolled in this course.';
$string['course_enrolled_teacher'] = 'You\'re teaching';
$string['course_enrolled_teacher_text'] = 'You are currently teaching this course.';
$string['course_error_title'] = 'Enrolment Error';
$string['course_error_text'] = 'Your administrator has not yet configured PayPal or Stripe Enrolment for this course.';
$string['course_price'] = 'Price';
$string['course_currency'] = '$';
$string['days'] = 'days';
$string['hours'] = 'Hours';
$string['minutes'] = 'Minutes';
$string['seconds'] = 'Seconds';
$string['username'] = 'Username';
$string['password'] = 'Password';
$string['notifications'] = 'Notifications';
$string['item'] = 'Item';
$string['your_order'] = 'Thank you for your order.';
$string['payment_method'] = 'Payment method:';
$string['receipt'] = 'Receipt';
$string['date'] = 'Enrolment starts';
$string['status'] = 'Status';
$string['total'] = 'Total';
$string['total_courses'] = 'Courses';
$string['price'] = 'Price';
$string['course_id'] = 'Course ID';
$string['action'] = 'Action';
$string['customer_id'] = 'Customer ID';
$string['customer_username'] = 'Customer name';
$string['customer_email'] = 'Customer email';
$string['completed'] = 'Paid';
$string['currency_symbol'] = '$';
$string['currency'] = 'USD';
$string['your_profile_views'] = 'Your Profile Views';
$string['profile_views'] = 'Profile views';
$string['your_profile_views_long'] = 'An overview of your profile visits over the last week';
$string['your_profile_views_dataset'] = 'Visits';
$string['instructors'] = 'Instructors';
$string['last_online'] = 'Last online';
$string['comments'] = 'comments';
$string['reviews'] = 'Reviews';
$string['preview_course'] = 'Preview Course';
$string['library'] = 'Library';
$string['have_an_account'] = 'Have an account?';
$string['course_content'] = 'Course Content';
$string['end_date'] = 'End date';
$string['view'] = 'View';
$string['published'] = 'Published';
$string['apostrophe_s'] = '\'s';
$string['stars_5'] = 'Stars 5';
$string['stars_4'] = 'Stars 4';
$string['stars_3'] = 'Stars 3';
$string['stars_2'] = 'Stars 2';
$string['stars_1'] = 'Stars 1';
$string['rated_by_none'] = 'No ratings yet';
$string['add_comment'] = 'Add a Comment & Review';
$string['speaks'] = 'Speaks:';
$string['scroll_down'] = 'Scroll Down';
$string['to_discover_more'] = 'to discover more';
$string['ccn_cf_free'] = 'Free';
$string['ccn_cf_paid'] = 'Paid';
$string['ccn_cf_5_stars'] = '5 stars and higher';
$string['ccn_cf_4_stars'] = '4 stars and higher';
$string['ccn_cf_3_stars'] = '3 stars and higher';
$string['ccn_cf_2_stars'] = '2 stars and higher';
$string['ccn_cf_1_stars'] = '1 star and higher';
$string['ccn_cf_show_all'] = 'Show all';
$string['ccn_cf_all_matching'] = 'All matching';
$string['no_students_yet'] = 'No students yet';
$string['no_courses_yet'] = 'No courses yet';
$string['interested_in'] = 'Interested in';
$string['uncategorized'] = 'Uncategorized';
